define([
    'User',
    'App',
],
function (User, app) {
    'use strict';

    return {
        isRoaAccepted: function () {
            var rightOfAccessAccepted = true;
            if (User && User.has('id')) {
                rightOfAccessAccepted = User.hasAcceptedROA();
            }
            return rightOfAccessAccepted;
        },

        navigateToRoa: function () {
            var path = app.resources.get('right-of-access').get('href');
            // no support for phonegapped version
            var newLocation = encodeURI(path + '?url=' + window.location.pathname);
            window.location = newLocation;
        },
    };
});
